/*
 * Decompiled with CFR 0.152.
 */
package CrossScroll;

import CrossScroll.AImage;
import CrossScroll.ATextWithFont;
import CrossScroll.IGraphicObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class AScrollTextDisplayer {
    protected int m_previousLineY = 0;
    protected int m_currentLineHeight = 0;
    protected int m_currentLineX = 0;
    protected int m_width = 0;
    protected int m_currentLineAlignment = 0;
    protected Vector graphicalObjectsVector = new Vector(10);
    protected Vector currentLineObjectsVector = new Vector(10);
    protected Vector linkObjectsVector = new Vector(10);
    public Color backColor = null;
    protected Graphics m_dummyGraphics = null;
    protected int m_deltaBetweenLines = 4;
    protected Vector paragraphLines = new Vector(5);

    public AScrollTextDisplayer(int n) {
        this.m_width = n;
    }

    public AScrollTextDisplayer(Graphics graphics, int n) {
        this.m_width = n;
        this.m_dummyGraphics = graphics;
    }

    protected void addFormattedExactText(String string, Font font, Color color, int n, String string2, String string3, int n2) {
        this.m_currentLineAlignment = n2;
        ATextWithFont aTextWithFont = new ATextWithFont(string, font, color, string2, string3);
        FontMetrics fontMetrics = this.m_dummyGraphics.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(string);
        aTextWithFont.boundingRectangle.x = this.m_currentLineX;
        if (n > this.m_currentLineHeight) {
            this.m_currentLineHeight = n;
            this.updateCurrentLine();
        }
        aTextWithFont.boundingRectangle.y = this.m_previousLineY;
        aTextWithFont.boundingRectangle.width = n3;
        aTextWithFont.boundingRectangle.height = this.m_currentLineHeight;
        this.graphicalObjectsVector.addElement(aTextWithFont);
        this.currentLineObjectsVector.addElement(aTextWithFont);
        if (this.m_currentLineAlignment == 1) {
            this.updateCurrentLineAlignment();
        }
        if (string2 != null) {
            this.linkObjectsVector.addElement(aTextWithFont);
        }
    }

    public void addFormattedText(String string, Font font, Color color, String string2, String string3, int n) {
        FontMetrics fontMetrics = this.m_dummyGraphics.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        while (true) {
            int n3;
            int n4;
            if ((n4 = fontMetrics.stringWidth(string)) + this.m_currentLineX <= this.m_width) {
                this.addFormattedExactText(string, font, color, n2, string2, string3, n);
                this.m_currentLineX += n4;
                break;
            }
            int n5 = this.m_width - this.m_currentLineX;
            int n6 = 1;
            while (n6 <= string.length()) {
                String string4 = string.substring(0, n6);
                n3 = fontMetrics.stringWidth(string4);
                if (n3 > n5) break;
                ++n6;
            }
            if (--n6 > 0) {
                int n7 = n6;
                while (n7 >= 0 && string.charAt(n7) != ' ') {
                    --n7;
                }
                if (n7 > 0) {
                    n3 = n7 + 1;
                    String string5 = string.substring(0, n3);
                    this.addFormattedExactText(string5, font, color, n2, string2, string3, n);
                    string = string.substring(n3, string.length());
                }
            }
            this.goToNextLine();
        }
    }

    public void addImage(Image image, int n, int n2, String string, String string2, int n3) {
        this.m_currentLineAlignment = n3;
        AImage aImage = new AImage(image, n, n2, string, string2);
        aImage.boundingRectangle.x = this.m_currentLineX;
        if (n2 > this.m_currentLineHeight) {
            this.m_currentLineHeight = n2;
            this.updateCurrentLine();
        }
        aImage.boundingRectangle.y = this.m_previousLineY;
        aImage.boundingRectangle.width = n;
        aImage.boundingRectangle.height = n2;
        this.graphicalObjectsVector.addElement(aImage);
        this.currentLineObjectsVector.addElement(aImage);
        this.m_currentLineX += n;
        if (this.m_currentLineAlignment == 1) {
            this.updateCurrentLineAlignment();
        }
        if (this.m_currentLineX > this.m_width) {
            this.goToNextLine();
        }
        if (string != null) {
            this.linkObjectsVector.addElement(aImage);
        }
    }

    public void addParagraphMark() {
        this.paragraphLines.addElement(new Integer(this.m_previousLineY));
    }

    public void drawAll(Graphics graphics, int n, int n2) {
        if (this.backColor != null) {
            Color color = graphics.getColor();
            graphics.setColor(this.backColor);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
        }
        int n3 = this.graphicalObjectsVector.size();
        int n4 = 0;
        while (n4 < n3) {
            ((IGraphicObject)this.graphicalObjectsVector.elementAt(n4)).drawGraphicObject(graphics);
            ++n4;
        }
    }

    public String getClickedLink(int n, int n2) {
        int n3 = this.linkObjectsVector.size();
        int n4 = 0;
        while (n4 < n3) {
            IGraphicObject iGraphicObject = (IGraphicObject)this.linkObjectsVector.elementAt(n4);
            if (iGraphicObject.boundingRectangle.contains(n, n2)) {
                return ((ATextWithFont)iGraphicObject).getURL();
            }
            ++n4;
        }
        return null;
    }

    public int getHeight() {
        return this.m_previousLineY + this.m_currentLineHeight;
    }

    public String getURL(int n) {
        if (n >= 0 && n < this.linkObjectsVector.size()) {
            Object e = this.linkObjectsVector.elementAt(n);
            return ((IGraphicObject)e).getURL();
        }
        return null;
    }

    public String getURLTarget(int n) {
        if (n >= 0 && n < this.linkObjectsVector.size()) {
            Object e = this.linkObjectsVector.elementAt(n);
            return ((IGraphicObject)e).linkTarget;
        }
        return null;
    }

    protected void goToNextLine() {
        if (this.m_currentLineHeight >= 0) {
            if (this.m_currentLineHeight == 0) {
                this.m_currentLineHeight = 10;
            }
            this.m_previousLineY += this.m_currentLineHeight + this.m_deltaBetweenLines;
            this.m_currentLineHeight = 0;
            this.m_currentLineX = 0;
            this.currentLineObjectsVector.removeAllElements();
        }
    }

    public boolean isParagraphStarted(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.paragraphLines.size()) {
            if ((Integer)this.paragraphLines.elementAt(n2) == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected void updateCurrentLine() {
        int n = this.currentLineObjectsVector.size();
        int n2 = 0;
        while (n2 < n) {
            ((IGraphicObject)this.currentLineObjectsVector.elementAt((int)n2)).boundingRectangle.height = this.m_currentLineHeight;
            ++n2;
        }
    }

    protected void updateCurrentLineAlignment() {
        if (this.m_currentLineAlignment == 0) {
            return;
        }
        int n = this.currentLineObjectsVector.size();
        if (n == 0) {
            return;
        }
        IGraphicObject iGraphicObject = null;
        int n2 = 0;
        iGraphicObject = (IGraphicObject)this.currentLineObjectsVector.elementAt(0);
        int n3 = iGraphicObject.boundingRectangle.x;
        iGraphicObject = (IGraphicObject)this.currentLineObjectsVector.elementAt(n - 1);
        int n4 = iGraphicObject.boundingRectangle.x + iGraphicObject.boundingRectangle.width;
        n2 = this.m_width / 2 - (n4 + n3) / 2;
        int n5 = 0;
        while (n5 < n) {
            IGraphicObject iGraphicObject2 = (IGraphicObject)this.currentLineObjectsVector.elementAt(n5);
            iGraphicObject2.boundingRectangle.x += n2;
            ++n5;
        }
        this.m_currentLineX += n2;
    }

    public int updateLinks(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.linkObjectsVector.size();
        int n5 = -1;
        IGraphicObject iGraphicObject = null;
        int n6 = 0;
        while (n6 < n4) {
            iGraphicObject = (IGraphicObject)this.linkObjectsVector.elementAt(n6);
            if (iGraphicObject.boundingRectangle.contains(n, n2)) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n3 != n5) {
            if (n5 != -1) {
                iGraphicObject.drawGraphicObject(graphics, n, n2);
            }
            if (n3 >= 0 && n3 < n4) {
                ((IGraphicObject)this.linkObjectsVector.elementAt(n3)).drawGraphicObject(graphics, n, n2);
            }
        }
        return n5;
    }
}

