/*
 * Decompiled with CFR 0.152.
 */
package CrossScroll;

import CrossScroll.AHTMLTag;
import CrossScroll.AScrollTextDisplayer;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class CrossText
extends Applet
implements MouseMotionListener,
MouseListener,
Runnable {
    Font m_font = new Font("Serif", 0, 14);
    String m_str = "";
    String m_strSpecialChars = null;
    Thread thread;
    int xPos = 5;
    private boolean bStartFromBottom = true;
    public Image m_offImage = null;
    public Graphics m_offGraphics = null;
    private int yStart = 0;
    private int savedY = 0;
    private boolean motionStopped = false;
    protected String bodyTag = "body";
    protected String underlineTag = "u";
    protected String boldTag = "b";
    protected String italicTag = "i";
    protected String fontTag = "font";
    protected String paragraphTag = "p";
    protected String lineBreakTag = "br";
    protected String imageTag = "img";
    protected String urlTag = "a";
    protected String titleTag = "title";
    protected String headTag = "head";
    protected String metaTag = "meta";
    protected String centerTag = "center";
    protected Font currentFont = null;
    protected AScrollTextDisplayer theScrollTextDisplayer = null;
    protected int m_currentIndex = 0;
    protected int m_lastMouseXPos = -1;
    protected int m_lastMouseYPos = -1;
    protected Color backColor = null;
    protected Color foreColor = null;
    protected Color m_linkColor = null;
    public static Color m_linkFocusColor = null;
    public static boolean m_bUnderlineLinks = true;
    protected int m_linkIndex = -1;
    protected int m_height = 0;
    protected Cursor m_handCursor = new Cursor(12);
    protected Cursor m_normalCursor = new Cursor(0);
    protected int m_initialDelay = 500;
    protected int m_smallSleep = 20;
    protected int m_scrollDelta = 1;
    private String m_userName = null;
    private int m_userKey = 0;
    protected String m_strHTMLFile = null;
    protected String m_strLinkTarget = null;
    protected String m_strSpecialsURL = "Specials.txt";
    protected boolean m_bAddLinesAfter = true;
    protected int m_nParagraphSleep = 0;
    private String m_strLoadText = null;
    protected boolean m_bTextLoaded = false;
    protected int m_nReloadCycle = 0;
    protected long m_lReloadTime = 0L;
    protected long m_lLastReloadTime = 0L;

    protected AHTMLTag extractHTMLTag() {
        String string;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string3 = null;
        AHTMLTag aHTMLTag = new AHTMLTag();
        ++this.m_currentIndex;
        n = this.m_currentIndex;
        while (this.m_str.charAt(this.m_currentIndex) != ' ' && this.m_str.charAt(this.m_currentIndex) != '>') {
            ++this.m_currentIndex;
        }
        n2 = this.m_currentIndex;
        string2 = this.m_str.substring(n, n2);
        aHTMLTag.setName(string2);
        n = n2;
        while (this.m_str.charAt(this.m_currentIndex) != '>') {
            if (!bl) {
                if (this.m_str.charAt(this.m_currentIndex) == ' ') {
                    ++n;
                }
                if (this.m_str.charAt(this.m_currentIndex) == '=') {
                    string3 = this.m_str.substring(n, this.m_currentIndex);
                    bl = true;
                    n = this.m_currentIndex + 1;
                }
            } else if (this.m_str.charAt(this.m_currentIndex) == ' ') {
                string = this.m_str.substring(n, this.m_currentIndex);
                aHTMLTag.addAttribute(string3, string);
                bl = false;
                n = this.m_currentIndex + 1;
            }
            ++this.m_currentIndex;
        }
        if (bl) {
            string = this.m_str.substring(n, this.m_currentIndex);
            aHTMLTag.addAttribute(string3, string);
        }
        ++this.m_currentIndex;
        return aHTMLTag;
    }

    public String getAppletInfo() {
        return "AXScroller\n\nHigh performance vertical scroller.\nCreation date: (2/14/00 3:31:51 PM)\n@author: \nAlexandru Indrei";
    }

    protected Color getColorFromString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string.charAt(0) == '#') {
            return Color.decode(string);
        }
        if (string.equalsIgnoreCase("red")) {
            n = 255;
        }
        if (string.equalsIgnoreCase("green")) {
            n2 = 255;
        }
        if (string.equalsIgnoreCase("blue")) {
            n3 = 255;
        }
        string.equalsIgnoreCase("black");
        if (string.equalsIgnoreCase("white")) {
            n3 = 255;
            n = 255;
            n2 = 255;
        }
        if (string.equalsIgnoreCase("gray")) {
            n3 = 127;
            n = 127;
            n2 = 127;
        }
        if (string.equalsIgnoreCase("yellow")) {
            n = 255;
            n2 = 255;
        }
        if (string.equalsIgnoreCase("magenta")) {
            n = 255;
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    protected AScrollTextDisplayer getDisplayer() {
        if (this.theScrollTextDisplayer == null) {
            this.theScrollTextDisplayer = new AScrollTextDisplayer(this.getGraphics(), this.getSize().width);
        }
        return this.theScrollTextDisplayer;
    }

    protected int getFontExactSize(int n) {
        switch (n) {
            case 1: {
                return 8;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 18;
            }
            case 6: {
                return 24;
            }
            case 7: {
                return 36;
            }
        }
        return 12;
    }

    protected String getFontFromHTML(String string) {
        String string2 = null;
        string2 = string.indexOf("arial") != -1 || string.indexOf("helvetica") != -1 ? new String("SansSerif") : (string.indexOf("times") != -1 ? new String("Serif") : (string.indexOf("courier") != -1 ? new String("Monospaced") : (string.equalsIgnoreCase("Serif") ? new String("Serif") : new String(string))));
        return string2;
    }

    protected int getIntFromString(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    protected char getSpecialChar(String string) {
        int n;
        if (this.m_strSpecialChars == null) {
            this.m_strSpecialChars = this.readFileInString(this.m_strSpecialsURL, false);
        }
        if ((n = this.m_strSpecialChars.indexOf(string)) == -1) {
            return 'a';
        }
        return this.m_strSpecialChars.charAt((n += string.length()) + 1);
    }

    public void init() {
        super.init();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.loadFromAppletParams();
    }

    protected void loadApplet() {
        this.m_currentIndex = 0;
        this.yStart = 0;
        this.theScrollTextDisplayer = null;
        this.m_str = this.readFileInString(this.m_strHTMLFile, true);
        this.parseHTMLTag(this.m_font, null, null, null, 0);
        if (this.verifyLicense() == 0) {
            this.getDisplayer().goToNextLine();
        }
        this.m_height = this.getDisplayer().getHeight();
        if (this.m_height < this.getSize().height || this.m_bAddLinesAfter) {
            this.m_height += this.getSize().height - this.m_height % this.getSize().height;
        }
        this.m_offImage = this.createImage(this.getSize().width, this.m_height);
        this.m_offGraphics = this.m_offImage.getGraphics();
        this.getDisplayer().backColor = this.backColor;
        this.getDisplayer().drawAll(this.m_offGraphics, this.getSize().width, this.m_height);
        this.m_bTextLoaded = true;
        System.gc();
    }

    protected void loadFromAppletParams() {
        String string = this.getParameter("htmlSourceFile");
        if (string != null) {
            this.m_strHTMLFile = string;
        }
        if ((string = this.getParameter("initialDelay")) != null) {
            this.m_initialDelay = this.getIntFromString(string);
        }
        if ((string = this.getParameter("normalDelay")) != null && this.getIntFromString(string) >= 0) {
            this.m_smallSleep = this.getIntFromString(string);
        }
        if ((string = this.getParameter("scrollStep")) != null && this.getIntFromString(string) >= 0) {
            this.m_scrollDelta = this.getIntFromString(string);
        }
        if ((string = this.getParameter("userName")) != null) {
            this.m_userName = new String(string);
        }
        if ((string = this.getParameter("userKey")) != null && this.getIntFromString(string) >= 0) {
            this.m_userKey = this.getIntFromString(string);
        }
        if ((string = this.getParameter("linkColor")) == null) {
            string = new String("blue");
        }
        this.m_linkColor = this.getColorFromString(string);
        string = this.getParameter("linkFocusColor");
        if (string == null) {
            string = new String("red");
        }
        m_linkFocusColor = this.getColorFromString(string);
        string = this.getParameter("underlineLinks");
        if (string != null && this.getIntFromString(string) >= 0) {
            m_bUnderlineLinks = this.getIntFromString(string) == 1;
        }
        this.m_strLinkTarget = (string = this.getParameter("linkTarget")) != null ? string : "_parent";
        string = this.getParameter("addLinesAfter");
        if (string != null && this.getIntFromString(string) >= 0) {
            boolean bl = this.m_bAddLinesAfter = this.getIntFromString(string) == 1;
        }
        if ((string = this.getParameter("specialCharsURL")) != null && string.length() > 0) {
            this.m_strSpecialsURL = new String(string);
        }
        if ((string = this.getParameter("paragraphDelay")) != null && this.getIntFromString(string) >= 0) {
            this.m_nParagraphSleep = this.getIntFromString(string);
        }
        if ((string = this.getParameter("loadingTextDisplay")) != null && string.length() > 0) {
            this.m_strLoadText = new String(string);
        }
        if ((string = this.getParameter("reloadCycle")) != null && this.getIntFromString(string) >= 0) {
            this.m_nReloadCycle = this.getIntFromString(string);
        }
        if ((string = this.getParameter("reloadTime")) != null && this.getIntFromString(string) >= 0) {
            this.m_lReloadTime = this.getIntFromString(string);
        }
    }

    protected Image loadImage(String string) {
        try {
            Image image = null;
            this.showStatus(String.valueOf(new String(" Loading image ")) + string);
            URL uRL = this.getCodeBase();
            image = this.getImage(uRL, string);
            if (image != null) {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {}
            }
            return image;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " occurred when trying to load image " + string);
            return null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        String string;
        mouseEvent.getX();
        mouseEvent.getY();
        String string2 = null;
        if (this.m_linkIndex != -1) {
            string2 = this.getDisplayer().getURL(this.m_linkIndex);
        }
        if ((string = this.getDisplayer().getURLTarget(this.m_linkIndex)) == null) {
            string = this.m_strLinkTarget;
        }
        if (string2 != null) {
            this.navigateURL(string2, string);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        this.yStart += n - this.savedY;
        if (this.yStart > 0 || this.yStart + this.m_height <= 0) {
            this.yStart = 0;
        }
        this.savedY = n;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.motionStopped = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_lastMouseXPos = -1;
        this.m_lastMouseYPos = -1;
        this.motionStopped = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_lastMouseXPos = mouseEvent.getX();
        this.m_lastMouseYPos = mouseEvent.getY();
        this.motionStopped = true;
        if (this.m_offGraphics == null) {
            return;
        }
        int n = -1;
        n = this.yStart + this.m_height > this.m_lastMouseYPos ? this.getDisplayer().updateLinks(this.m_offGraphics, this.m_lastMouseXPos, this.m_lastMouseYPos - this.yStart, this.m_linkIndex) : this.getDisplayer().updateLinks(this.m_offGraphics, this.m_lastMouseXPos, this.m_lastMouseYPos - this.yStart - this.m_height, this.m_linkIndex);
        if (this.m_linkIndex != n) {
            this.m_linkIndex = n;
            if (this.m_linkIndex != -1) {
                this.setCursor(this.m_handCursor);
                this.showStatus(this.getDisplayer().getURL(this.m_linkIndex));
            } else {
                this.setCursor(this.m_normalCursor);
                this.showStatus(null);
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.savedY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void navigateURL(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL(this.getCodeBase(), string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.err.println("Bad url: " + string);
            }
        }
        if (uRL != null) {
            this.getAppletContext().showDocument(uRL, string2);
        }
    }

    protected void normalSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void paint(Graphics graphics) {
        if (this.m_bTextLoaded) {
            graphics.drawImage(this.m_offImage, 0, this.yStart, this);
            if (this.yStart + this.m_height < this.getSize().height) {
                graphics.drawImage(this.m_offImage, 0, this.yStart + this.m_height, this);
            }
        } else if (this.m_strLoadText != null) {
            graphics.drawString(this.m_strLoadText, 10, 20);
        }
    }

    protected void parseHTMLTag(Font font, Color color, String string, String string2, int n) {
        int n2;
        Font font2 = null;
        Color color2 = null;
        String string3 = null;
        if (string != null) {
            string3 = new String(string);
        }
        String string4 = null;
        if (string2 != null) {
            string4 = new String(string2);
        }
        boolean bl = true;
        int n3 = n;
        String string5 = font.getName();
        int n4 = font.getSize();
        int n5 = font.getStyle();
        int n6 = this.m_str.length();
        if (color != null) {
            color2 = new Color(color.getRGB());
        }
        this.m_str.substring(this.m_currentIndex);
        AHTMLTag aHTMLTag = this.extractHTMLTag();
        if (aHTMLTag != null) {
            if (aHTMLTag.is(this.paragraphTag) || aHTMLTag.is(this.lineBreakTag)) {
                this.getDisplayer().goToNextLine();
                if (aHTMLTag.is(this.paragraphTag)) {
                    this.getDisplayer().addParagraphMark();
                }
                return;
            }
            if (aHTMLTag.is(this.titleTag) || aHTMLTag.is(this.headTag)) {
                bl = false;
            }
            if (aHTMLTag.is(this.centerTag)) {
                n3 = 1;
            }
            if (aHTMLTag.is(this.bodyTag)) {
                int n7 = 0;
                while (n7 < aHTMLTag.getNoOfAttributes()) {
                    String string6;
                    if (aHTMLTag.getAttributeName(n7).equalsIgnoreCase("bgcolor")) {
                        string6 = aHTMLTag.getAttributeValue(n7);
                        this.backColor = this.getColorFromString(string6);
                    }
                    if (aHTMLTag.getAttributeName(n7).equalsIgnoreCase("text")) {
                        string6 = aHTMLTag.getAttributeValue(n7);
                        color2 = this.getColorFromString(string6);
                    }
                    ++n7;
                }
                font2 = new Font(string5, n5, n4);
            } else if (aHTMLTag.is(this.boldTag)) {
                font2 = new Font(string5, n5 | 1, n4);
            } else if (aHTMLTag.is(this.underlineTag)) {
                font2 = new Font(string5, n5, n4);
            } else if (aHTMLTag.is(this.italicTag)) {
                font2 = new Font(string5, n5 | 2, n4);
            } else if (aHTMLTag.is(this.fontTag)) {
                String string7 = string5;
                int n8 = n4;
                n2 = 0;
                while (n2 < aHTMLTag.getNoOfAttributes()) {
                    String string8;
                    if (aHTMLTag.getAttributeName(n2).equalsIgnoreCase("face")) {
                        string7 = this.getFontFromHTML(aHTMLTag.getAttributeValue(n2));
                    }
                    if (aHTMLTag.getAttributeName(n2).equalsIgnoreCase("size")) {
                        string8 = aHTMLTag.getAttributeValue(n2);
                        int n9 = 0;
                        char c = string8.charAt(n9++);
                        int n10 = 3;
                        int n11 = 1;
                        if (c == '-') {
                            n11 = -1;
                        } else if (c == '+') {
                            n11 = 1;
                        } else {
                            n10 = 0;
                            --n9;
                        }
                        c = string8.charAt(n9);
                        int n12 = n10 + n11 * (c - 48);
                        n8 = this.getFontExactSize(n12);
                    }
                    if (aHTMLTag.getAttributeName(n2).equalsIgnoreCase("color")) {
                        string8 = aHTMLTag.getAttributeValue(n2);
                        color2 = this.getColorFromString(string8);
                    }
                    ++n2;
                }
                font2 = new Font(string7, n5, n8);
            } else {
                if (aHTMLTag.is(this.imageTag)) {
                    String string9 = null;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 < aHTMLTag.getNoOfAttributes()) {
                        Integer n16;
                        if (aHTMLTag.getAttributeName(n15).equalsIgnoreCase("src")) {
                            string9 = aHTMLTag.getAttributeValue(n15);
                        }
                        if (aHTMLTag.getAttributeName(n15).equalsIgnoreCase("width")) {
                            n16 = new Integer(aHTMLTag.getAttributeValue(n15));
                            n13 = n16;
                        }
                        if (aHTMLTag.getAttributeName(n15).equalsIgnoreCase("height")) {
                            n16 = new Integer(aHTMLTag.getAttributeValue(n15));
                            n14 = n16;
                        }
                        ++n15;
                    }
                    if (string9 != null) {
                        Image image = this.loadImage(string9);
                        this.getDisplayer().addImage(image, n13, n14, string3, string4, n3);
                    }
                    return;
                }
                if (aHTMLTag.is(this.metaTag)) {
                    return;
                }
                if (aHTMLTag.is(this.urlTag)) {
                    int n17 = 0;
                    while (n17 < aHTMLTag.getNoOfAttributes()) {
                        if (aHTMLTag.getAttributeName(n17).equalsIgnoreCase("href")) {
                            string3 = aHTMLTag.getAttributeValue(n17);
                        }
                        if (aHTMLTag.getAttributeName(n17).equalsIgnoreCase("target")) {
                            string4 = aHTMLTag.getAttributeValue(n17);
                        }
                        ++n17;
                    }
                    font2 = new Font(string5, n5, n4);
                    if (this.m_linkColor != null) {
                        color2 = this.m_linkColor;
                    }
                } else {
                    font2 = new Font(string5, n5, n4);
                }
            }
        }
        String string10 = "";
        while (this.m_currentIndex < n6) {
            boolean bl2 = false;
            n2 = this.m_str.charAt(this.m_currentIndex);
            if (n2 == 38) {
                int n18 = this.m_currentIndex;
                while ((n2 = this.m_str.charAt(++this.m_currentIndex)) != 59) {
                }
                String string11 = this.m_str.substring(n18, this.m_currentIndex + 1);
                n2 = this.getSpecialChar(string11);
                if (n2 == 97) {
                    ++this.m_currentIndex;
                    continue;
                }
                bl2 = true;
            }
            if (n2 == 60 && !bl2) {
                if (string10.length() > 0 && bl) {
                    this.getDisplayer().addFormattedText(string10, font2, color2, string3, string4, n3);
                }
                if (this.m_str.charAt(this.m_currentIndex + 1) == '/') {
                    ++this.m_currentIndex;
                    n2 = this.m_str.charAt(this.m_currentIndex);
                    while (this.m_currentIndex < n6 && n2 != 62) {
                        ++this.m_currentIndex;
                        n2 = this.m_str.charAt(this.m_currentIndex);
                    }
                    if (this.m_currentIndex < n6) {
                        ++this.m_currentIndex;
                    }
                    return;
                }
                this.parseHTMLTag(font2, color2, string3, string4, n3);
                string10 = "";
                continue;
            }
            string10 = String.valueOf(string10) + (char)n2;
            ++this.m_currentIndex;
        }
        if (string10.length() > 0 && bl) {
            this.getDisplayer().addFormattedText(string10, font2, color2, string3, string4, n3);
        }
    }

    protected String readFileInString(String string, boolean bl) {
        URL uRL = null;
        String string2 = new String();
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            try {
                uRL = new URL(this.getDocumentBase(), string);
            }
            catch (Exception exception2) {
                System.out.println("Error Reading file");
            }
        }
        try {
            String string3;
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            int n = 62;
            while ((string3 = dataInputStream.readLine()) != null) {
                if (bl) {
                    string3 = string3.trim();
                }
                if (n != 62 || string3.length() == 0 || string3.charAt(0) != '<') {
                    string2 = String.valueOf(string2) + " ";
                }
                string2 = String.valueOf(string2) + string3;
                if (string3.length() <= 0) continue;
                n = string3.charAt(string3.length() - 1);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error Reading Special chars file");
        }
        return string2;
    }

    public void run() {
        this.repaint();
        if (!this.m_bTextLoaded) {
            this.loadApplet();
            this.repaint();
            this.m_lLastReloadTime = System.currentTimeMillis();
        }
        int n = 0;
        int n2 = this.m_initialDelay;
        while (true) {
            if (!this.motionStopped) {
                long l;
                this.yStart -= this.m_scrollDelta;
                if (this.yStart + this.m_height <= 0) {
                    this.yStart = 0;
                    if (this.m_nReloadCycle > 0 && ++n >= this.m_nReloadCycle) {
                        this.loadApplet();
                        n = 0;
                    }
                }
                if (this.m_nParagraphSleep > 0 && this.getDisplayer().isParagraphStarted(-this.yStart)) {
                    this.smartSleep(this.m_nParagraphSleep);
                }
                if (this.m_lReloadTime > 0L && (l = System.currentTimeMillis()) - this.m_lLastReloadTime >= this.m_lReloadTime) {
                    this.loadApplet();
                    this.m_lLastReloadTime = l;
                }
                this.repaint();
            }
            this.smartSleep(n2);
            n2 = this.m_smallSleep;
        }
    }

    protected void smartSleep(int n) {
        if (n < 10) {
            this.normalSleep(n);
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        while (l2 > l) {
            this.normalSleep(10);
            l2 -= 10L;
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private int verifyLicense() {
        if (this.m_userName == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_userName.length()) {
            n += this.m_userName.charAt(n2);
            ++n2;
        }
        return (n = n % 333 * 2 - 1) != this.m_userKey ? 0 : 1;
    }
}

